// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Atom;
use crate::AxisFlags;
use crate::AxisUse;
use crate::DeviceManager;
use crate::DeviceTool;
use crate::DeviceType;
use crate::Display;
use crate::InputMode;
use crate::InputSource;
use crate::ModifierType;
use crate::Screen;
use crate::Seat;
use crate::Window;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GdkDevice")]
    pub struct Device(Object<ffi::GdkDevice>);

    match fn {
        type_ => || ffi::gdk_device_get_type(),
    }
}

impl Device {
    #[doc(alias = "gdk_device_get_associated_device")]
    #[doc(alias = "get_associated_device")]
    #[must_use]
    pub fn associated_device(&self) -> Option<Device> {
        unsafe { from_glib_none(ffi::gdk_device_get_associated_device(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_axes")]
    #[doc(alias = "get_axes")]
    pub fn axes(&self) -> AxisFlags {
        unsafe { from_glib(ffi::gdk_device_get_axes(self.to_glib_none().0)) }
    }

    //#[doc(alias = "gdk_device_get_axis")]
    //#[doc(alias = "get_axis")]
    //pub fn axis(&self, axes: &[f64], use_: AxisUse) -> Option<f64> {
    //    unsafe { TODO: call ffi:gdk_device_get_axis() }
    //}

    #[doc(alias = "gdk_device_get_axis_use")]
    #[doc(alias = "get_axis_use")]
    pub fn axis_use(&self, index_: u32) -> AxisUse {
        unsafe { from_glib(ffi::gdk_device_get_axis_use(self.to_glib_none().0, index_)) }
    }

    //#[doc(alias = "gdk_device_get_axis_value")]
    //#[doc(alias = "get_axis_value")]
    //pub fn axis_value(&self, axes: &[f64], axis_label: &Atom) -> Option<f64> {
    //    unsafe { TODO: call ffi:gdk_device_get_axis_value() }
    //}

    #[doc(alias = "gdk_device_get_device_type")]
    #[doc(alias = "get_device_type")]
    pub fn device_type(&self) -> DeviceType {
        unsafe { from_glib(ffi::gdk_device_get_device_type(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_display")]
    #[doc(alias = "get_display")]
    pub fn display(&self) -> Display {
        unsafe { from_glib_none(ffi::gdk_device_get_display(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_has_cursor")]
    #[doc(alias = "get_has_cursor")]
    pub fn has_cursor(&self) -> bool {
        unsafe { from_glib(ffi::gdk_device_get_has_cursor(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_key")]
    #[doc(alias = "get_key")]
    pub fn key(&self, index_: u32) -> Option<(u32, ModifierType)> {
        unsafe {
            let mut keyval = mem::MaybeUninit::uninit();
            let mut modifiers = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gdk_device_get_key(
                self.to_glib_none().0,
                index_,
                keyval.as_mut_ptr(),
                modifiers.as_mut_ptr(),
            ));
            if ret {
                Some((keyval.assume_init(), from_glib(modifiers.assume_init())))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gdk_device_get_last_event_window")]
    #[doc(alias = "get_last_event_window")]
    pub fn last_event_window(&self) -> Option<Window> {
        unsafe { from_glib_none(ffi::gdk_device_get_last_event_window(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_mode")]
    #[doc(alias = "get_mode")]
    pub fn mode(&self) -> InputMode {
        unsafe { from_glib(ffi::gdk_device_get_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_n_axes")]
    #[doc(alias = "get_n_axes")]
    pub fn n_axes(&self) -> i32 {
        unsafe { ffi::gdk_device_get_n_axes(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_device_get_n_keys")]
    #[doc(alias = "get_n_keys")]
    pub fn n_keys(&self) -> i32 {
        unsafe { ffi::gdk_device_get_n_keys(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_device_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_device_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_position")]
    #[doc(alias = "get_position")]
    pub fn position(&self) -> (Screen, i32, i32) {
        unsafe {
            let mut screen = ptr::null_mut();
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gdk_device_get_position(
                self.to_glib_none().0,
                &mut screen,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (from_glib_none(screen), x.assume_init(), y.assume_init())
        }
    }

    #[doc(alias = "gdk_device_get_position_double")]
    #[doc(alias = "get_position_double")]
    pub fn position_double(&self) -> (Screen, f64, f64) {
        unsafe {
            let mut screen = ptr::null_mut();
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gdk_device_get_position_double(
                self.to_glib_none().0,
                &mut screen,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (from_glib_none(screen), x.assume_init(), y.assume_init())
        }
    }

    #[doc(alias = "gdk_device_get_product_id")]
    #[doc(alias = "get_product_id")]
    pub fn product_id(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_device_get_product_id(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_seat")]
    #[doc(alias = "get_seat")]
    pub fn seat(&self) -> Option<Seat> {
        unsafe { from_glib_none(ffi::gdk_device_get_seat(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_source")]
    #[doc(alias = "get_source")]
    pub fn source(&self) -> InputSource {
        unsafe { from_glib(ffi::gdk_device_get_source(self.to_glib_none().0)) }
    }

    //#[doc(alias = "gdk_device_get_state")]
    //#[doc(alias = "get_state")]
    //pub fn state(&self, window: &Window, axes: &[f64]) -> ModifierType {
    //    unsafe { TODO: call ffi:gdk_device_get_state() }
    //}

    #[doc(alias = "gdk_device_get_vendor_id")]
    #[doc(alias = "get_vendor_id")]
    pub fn vendor_id(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_device_get_vendor_id(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_device_get_window_at_position")]
    #[doc(alias = "get_window_at_position")]
    pub fn window_at_position(&self) -> (Option<Window>, i32, i32) {
        unsafe {
            let mut win_x = mem::MaybeUninit::uninit();
            let mut win_y = mem::MaybeUninit::uninit();
            let ret = from_glib_none(ffi::gdk_device_get_window_at_position(
                self.to_glib_none().0,
                win_x.as_mut_ptr(),
                win_y.as_mut_ptr(),
            ));
            (ret, win_x.assume_init(), win_y.assume_init())
        }
    }

    #[doc(alias = "gdk_device_get_window_at_position_double")]
    #[doc(alias = "get_window_at_position_double")]
    pub fn window_at_position_double(&self) -> (Option<Window>, f64, f64) {
        unsafe {
            let mut win_x = mem::MaybeUninit::uninit();
            let mut win_y = mem::MaybeUninit::uninit();
            let ret = from_glib_none(ffi::gdk_device_get_window_at_position_double(
                self.to_glib_none().0,
                win_x.as_mut_ptr(),
                win_y.as_mut_ptr(),
            ));
            (ret, win_x.assume_init(), win_y.assume_init())
        }
    }

    #[doc(alias = "gdk_device_list_axes")]
    pub fn list_axes(&self) -> Vec<Atom> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_device_list_axes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_device_list_slave_devices")]
    pub fn list_slave_devices(&self) -> Vec<Device> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_device_list_slave_devices(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_device_set_axis_use")]
    pub fn set_axis_use(&self, index_: u32, use_: AxisUse) {
        unsafe {
            ffi::gdk_device_set_axis_use(self.to_glib_none().0, index_, use_.into_glib());
        }
    }

    #[doc(alias = "gdk_device_set_key")]
    pub fn set_key(&self, index_: u32, keyval: u32, modifiers: ModifierType) {
        unsafe {
            ffi::gdk_device_set_key(self.to_glib_none().0, index_, keyval, modifiers.into_glib());
        }
    }

    #[doc(alias = "gdk_device_set_mode")]
    pub fn set_mode(&self, mode: InputMode) -> bool {
        unsafe {
            from_glib(ffi::gdk_device_set_mode(
                self.to_glib_none().0,
                mode.into_glib(),
            ))
        }
    }

    #[doc(alias = "gdk_device_warp")]
    pub fn warp(&self, screen: &Screen, x: i32, y: i32) {
        unsafe {
            ffi::gdk_device_warp(self.to_glib_none().0, screen.to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "device-manager")]
    pub fn device_manager(&self) -> Option<DeviceManager> {
        glib::ObjectExt::property(self, "device-manager")
    }

    #[doc(alias = "input-mode")]
    pub fn input_mode(&self) -> InputMode {
        glib::ObjectExt::property(self, "input-mode")
    }

    #[doc(alias = "input-mode")]
    pub fn set_input_mode(&self, input_mode: InputMode) {
        glib::ObjectExt::set_property(self, "input-mode", &input_mode)
    }

    #[doc(alias = "input-source")]
    pub fn input_source(&self) -> InputSource {
        glib::ObjectExt::property(self, "input-source")
    }

    #[doc(alias = "num-touches")]
    pub fn num_touches(&self) -> u32 {
        glib::ObjectExt::property(self, "num-touches")
    }

    pub fn set_seat(&self, seat: Option<&Seat>) {
        glib::ObjectExt::set_property(self, "seat", &seat)
    }

    pub fn tool(&self) -> Option<DeviceTool> {
        glib::ObjectExt::property(self, "tool")
    }

    #[doc(alias = "type")]
    pub fn type_(&self) -> DeviceType {
        glib::ObjectExt::property(self, "type")
    }

    #[doc(alias = "changed")]
    pub fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tool-changed")]
    pub fn connect_tool_changed<F: Fn(&Self, &DeviceTool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn tool_changed_trampoline<F: Fn(&Device, &DeviceTool) + 'static>(
            this: *mut ffi::GdkDevice,
            tool: *mut ffi::GdkDeviceTool,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(tool))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"tool-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    tool_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "associated-device")]
    pub fn connect_associated_device_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_associated_device_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::associated-device\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_associated_device_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "axes")]
    pub fn connect_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_axes_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::axes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_axes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-mode")]
    pub fn connect_input_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_mode_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "n-axes")]
    pub fn connect_n_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_axes_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-axes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_n_axes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "seat")]
    pub fn connect_seat_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_seat_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::seat\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_seat_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tool")]
    pub fn connect_tool_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tool_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tool\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tool_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "type")]
    pub fn connect_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_type_trampoline<F: Fn(&Device) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Device {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Device")
    }
}
