% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Set or query message sensitivity}
\usage{
sensitivity(msg, sensitivity = NULL)
}
\arguments{
\item{msg}{A message object.}

\item{sensitivity}{Sensitivity level. One of \code{"personal"}, \code{"private"}, or \code{"company-confidential"}.}
}
\value{
A message object.
}
\description{
Manipulate the \code{Sensitivity} field as specified in \href{https://www.ietf.org/rfc/rfc2156.txt}{RFC 2156}.
}
\examples{
# Not sensitive.
envelope() \%>\%
  subject("Your daily dose of spam")

# Sensitive personal message.
envelope() \%>\%
  subject("The results from your test") \%>\%
  sensitivity("personal")

# Sensitive private message.
envelope() \%>\%
  subject("Your OTP (don't show this to anybody!") \%>\%
  sensitivity("private")

# Sensitive business message.
envelope() \%>\%
  subject("Top Secret Strategy Document") \%>\%
  sensitivity("company-confidential")

}
